"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, name: str, block_address: Dict, digest_tip_address: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a block object at a specified address in a journal. Also returns a proof of the specified block for verification if DigestTipAddress is provided. For information about the data contents in a block, see Journal contents in the Amazon QLDB Developer Guide. If the specified ledger doesn't exist or is in DELETING status, then throws ResourceNotFoundException. If the specified ledger is in CREATING status, then throws ResourcePreconditionNotMetException. If no block exists with the specified address, then throws InvalidParameterException.

    Args:
        name(str): The name of the ledger.
        block_address(Dict): The location of the block that you want to request. An address is an Amazon Ion structure that has two fields: strandId and sequenceNo. For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}.
        digest_tip_address(Dict, optional): The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: strandId and sequenceNo. For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.block.get(ctx, name=value, block_address=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.block.get name=value, block_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="get_block",
        op_kwargs={
            "Name": name,
            "BlockAddress": block_address,
            "DigestTipAddress": digest_tip_address,
        },
    )
