"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List tags for a resource. For more information, see AWS Proton resources and tagging in the AWS Proton Administrator Guide or AWS Proton User Guide.

    Args:
        max_results(int, optional): The maximum number of tags to list. Defaults to None.
        next_token(str, optional): A token to indicate the location of the next resource tag in the array of resource tags, after the list of resource tags that was previously requested. Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) of the resource for the listed tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.tags_for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.tags_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="list_tags_for_resource",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "resourceArn": resource_arn,
        },
    )
