"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    compatible_environment_templates: List,
    source: Dict,
    template_name: str,
    client_token: str = None,
    description: str = None,
    major_version: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new major or minor version of a service template. A major version of a service template is a version that isn't backwards compatible. A minor version of a service template is a version that's backwards compatible within its major version.

    Args:
        client_token(str, optional): When included, if two identicial requests are made with the same client token, AWS Proton returns the service template version that the first request created. Defaults to None.
        compatible_environment_templates(List): An array of compatible environment template objects for the new version of a service template.
        description(str, optional): A description of the new version of a service template. Defaults to None.
        major_version(str, optional): To create a new minor version of the service template, include a majorVersion. To create a new major and minor version of the service template, exclude majorVersion. Defaults to None.
        source(Dict): An object that includes the template bundle S3 bucket path and name for the new version of a service template.
        tags(List, optional): Create tags for a new version of a service template. Defaults to None.
        template_name(str): The name of the service template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.version.create(
                ctx, compatible_environment_templates=value, source=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.version.create compatible_environment_templates=value, source=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="create_service_template_version",
        op_kwargs={
            "clientToken": client_token,
            "compatibleEnvironmentTemplates": compatible_environment_templates,
            "description": description,
            "majorVersion": major_version,
            "source": source,
            "tags": tags,
            "templateName": template_name,
        },
    )


async def delete(
    hub, ctx, major_version: str, minor_version: str, template_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    If no other minor versions of a service template exist, delete a major version of the service template if it's not the Recommended version. Delete the Recommended version of the service template if no other major versions or minor versions of the service template exist. A major version of a service template is a version that isn't backwards compatible. Delete a minor version of a service template if it's not the Recommended version. Delete a Recommended minor version of the service template if no other minor versions of the service template exist. A minor version of a service template is a version that's backwards compatible.

    Args:
        major_version(str): The service template major version to delete.
        minor_version(str): The service template minor version to delete.
        template_name(str): The name of the service template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.version.delete(
                ctx, major_version=value, minor_version=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.version.delete major_version=value, minor_version=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="delete_service_template_version",
        op_kwargs={
            "majorVersion": major_version,
            "minorVersion": minor_version,
            "templateName": template_name,
        },
    )


async def get(
    hub, ctx, major_version: str, minor_version: str, template_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    View detail data for a major or minor version of a service template.

    Args:
        major_version(str): To view service template major version detail data, include majorVersion.
        minor_version(str): To view service template minor version detail data, include minorVersion.
        template_name(str): The name of the service template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.version.get(
                ctx, major_version=value, minor_version=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.version.get major_version=value, minor_version=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="get_service_template_version",
        op_kwargs={
            "majorVersion": major_version,
            "minorVersion": minor_version,
            "templateName": template_name,
        },
    )


async def list_all(
    hub,
    ctx,
    template_name: str,
    major_version: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List major or minor versions of a service template with detail data.

    Args:
        major_version(str, optional): To view a list of minor of versions under a major version of a service template, include majorVersion. To view a list of major versions of a service template, exclude majorVersion. Defaults to None.
        max_results(int, optional): The maximum number of major or minor versions of a service template to list. Defaults to None.
        next_token(str, optional): A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after the list of major or minor versions that was previously requested. Defaults to None.
        template_name(str): The name of the service template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.version.list_all(
                ctx, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.version.list_all template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="list_service_template_versions",
        op_kwargs={
            "majorVersion": major_version,
            "maxResults": max_results,
            "nextToken": next_token,
            "templateName": template_name,
        },
    )


async def update(
    hub,
    ctx,
    major_version: str,
    minor_version: str,
    template_name: str,
    compatible_environment_templates: List = None,
    description: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a major or minor version of a service template.

    Args:
        compatible_environment_templates(List, optional): An array of compatible environment names for a service template major or minor version to update. Defaults to None.
        description(str, optional): A description of a service template version to update. Defaults to None.
        major_version(str): To update a major version of a service template, include majorVersion.
        minor_version(str): To update a minor version of a service template, include minorVersion.
        status(str, optional): The status of the service template minor version to update. Defaults to None.
        template_name(str): The name of the service template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.version.update(
                ctx, major_version=value, minor_version=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.version.update major_version=value, minor_version=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="update_service_template_version",
        op_kwargs={
            "compatibleEnvironmentTemplates": compatible_environment_templates,
            "description": description,
            "majorVersion": major_version,
            "minorVersion": minor_version,
            "status": status,
            "templateName": template_name,
        },
    )
