"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    display_name: str = None,
    encryption_key: str = None,
    pipeline_provisioning: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a service template. The administrator creates a service template to define standardized infrastructure and an optional CICD service pipeline. Developers, in turn, select the service template from AWS Proton. If the selected service template includes a service pipeline definition, they provide a link to their source code repository. AWS Proton then deploys and manages the infrastructure defined by the selected service template. For more information, see Service Templates in the AWS Proton Administrator Guide.

    Args:
        description(str, optional): A description of the service template. Defaults to None.
        display_name(str, optional): The name of the service template as displayed in the developer interface. Defaults to None.
        encryption_key(str, optional): A customer provided encryption key that's used to encrypt data. Defaults to None.
        name(str): The name of the service template.
        pipeline_provisioning(str, optional): AWS Proton includes a service pipeline for your service by default. When included, this parameter indicates that an AWS Proton service pipeline won't be included for your service. Once specified, this parameter can't be changed. For more information, see Service template bundles in the AWS Proton Administrator Guide. Defaults to None.
        tags(List, optional): Create tags for your service template. For more information, see AWS Proton resources and tagging in the AWS Proton Administrator Guide or AWS Proton User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="create_service_template",
        op_kwargs={
            "description": description,
            "displayName": display_name,
            "encryptionKey": encryption_key,
            "name": name,
            "pipelineProvisioning": pipeline_provisioning,
            "tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    If no other major or minor versions of the service template exist, delete the service template.

    Args:
        name(str): The name of the service template to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="delete_service_template",
        op_kwargs={"name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Get detail data for a service template.

    Args:
        name(str): The name of the service template that you want to get detail data for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="get_service_template",
        op_kwargs={"name": name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List service templates with detail data.

    Args:
        max_results(int, optional): The maximum number of service templates to list. Defaults to None.
        next_token(str, optional): A token to indicate the location of the next service template in the array of service templates, after the list of service templates previously requested. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="list_service_templates",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub, ctx, name: str, description: str = None, display_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Update a service template.

    Args:
        description(str, optional): A description of the service template update. Defaults to None.
        display_name(str, optional): The name of the service template to update as displayed in the developer interface. Defaults to None.
        name(str): The name of the service template to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.template.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.template.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="update_service_template",
        op_kwargs={
            "description": description,
            "displayName": display_name,
            "name": name,
        },
    )
