"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, name: str, service_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Get detail data for a service instance. A service instance is an instantiation of service template, which is running in a specific environment.

    Args:
        name(str): The name of a service instance that you want to get the detail data for.
        service_name(str): The name of the service that the service instance belongs to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.instance.init.get(
                ctx, name=value, service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.instance.init.get name=value, service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="get_service_instance",
        op_kwargs={"name": name, "serviceName": service_name},
    )


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, service_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List service instances with summaries of detail data.

    Args:
        max_results(int, optional): The maximum number of service instances to list. Defaults to None.
        next_token(str, optional): A token to indicate the location of the next service in the array of service instances, after the list of service instances that was previously requested. Defaults to None.
        service_name(str, optional): The name of the service that the service instance belongs to. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.instance.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.instance.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="list_service_instances",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "serviceName": service_name,
        },
    )


async def update(
    hub,
    ctx,
    deployment_type: str,
    name: str,
    service_name: str,
    spec: str = None,
    template_major_version: str = None,
    template_minor_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a service instance. There are four modes for updating a service instance as described in the following. The deploymentType field defines the mode.     NONE  In this mode, a deployment doesn't occur. Only the requested metadata parameters are updated.     CURRENT_VERSION  In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are updated. Don’t include minor or major version parameters when you use this deployment-type.     MINOR_VERSION  In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.     MAJOR_VERSION  In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that is higher than the major version in use and a minor version (optional).

    Args:
        deployment_type(str): The deployment type. There are four modes for updating a service instance as described in the following. The deploymentType field defines the mode.     NONE  In this mode, a deployment doesn't occur. Only the requested metadata parameters are updated.     CURRENT_VERSION  In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are updated. Don’t include minor or major version parameters when you use this deployment-type.     MINOR_VERSION  In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.     MAJOR_VERSION  In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that is higher than the major version in use and a minor version (optional).  .
        name(str): The name of the service instance to update.
        service_name(str): The name of the service that the service instance belongs to.
        spec(str, optional): The formatted specification that defines the service instance update. Defaults to None.
        template_major_version(str, optional): The major version of the service template to update. Defaults to None.
        template_minor_version(str, optional): The minor version of the service template to update. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.instance.init.update(
                ctx, deployment_type=value, name=value, service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.instance.init.update deployment_type=value, name=value, service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="update_service_instance",
        op_kwargs={
            "deploymentType": deployment_type,
            "name": name,
            "serviceName": service_name,
            "spec": spec,
            "templateMajorVersion": template_major_version,
            "templateMinorVersion": template_minor_version,
        },
    )
