"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, service_instance_name: str, service_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Attempts to cancel a service instance deployment on an UpdateServiceInstance action, if the deployment is IN_PROGRESS. For more information, see Update a service instance in the AWS Proton Administrator guide or the AWS Proton User guide. The following list includes potential cancellation scenarios.   If the cancellation attempt succeeds, the resulting deployment state is CANCELLED.   If the cancellation attempt fails, the resulting deployment state is FAILED.   If the current UpdateServiceInstance action succeeds before the cancellation attempt starts, the resulting deployment state is SUCCEEDED and the cancellation attempt has no effect.

    Args:
        service_instance_name(str): The name of the service instance with the deployment to cancel.
        service_name(str): The name of the service with the service instance deployment to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.instance.deployment.cancel(
                ctx, service_instance_name=value, service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.instance.deployment.cancel service_instance_name=value, service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="cancel_service_instance_deployment",
        op_kwargs={
            "serviceInstanceName": service_instance_name,
            "serviceName": service_name,
        },
    )
