"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    spec: str,
    template_major_version: str,
    template_name: str,
    branch_name: str = None,
    description: str = None,
    repository_connection_arn: str = None,
    repository_id: str = None,
    tags: List = None,
    template_minor_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an AWS Proton service. An AWS Proton service is an instantiation of a service template and often includes several service instances and pipeline. For more information, see Services in the AWS Proton Administrator Guide and Services in the AWS Proton User Guide.

    Args:
        branch_name(str, optional): The name of the code repository branch that holds the code that's deployed in AWS Proton. Don't include this parameter if your service template doesn't include a service pipeline. Defaults to None.
        description(str, optional): A description of the AWS Proton service. Defaults to None.
        name(str): The service name.
        repository_connection_arn(str, optional): The Amazon Resource Name (ARN) of the repository connection. For more information, see Set up repository connection in the AWS Proton Administrator Guide and Setting up with AWS Proton in the AWS Proton User Guide. Don't include this parameter if your service template doesn't include a service pipeline. Defaults to None.
        repository_id(str, optional): The ID of the code repository. Don't include this parameter if your service template doesn't include a service pipeline. Defaults to None.
        spec(str): A link to a spec file that provides inputs as defined in the service template bundle schema file. The spec file is in YAML format. Don’t include pipeline inputs in the spec if your service template doesn’t include a service pipeline. For more information, see Create a service in the AWS Proton Administrator Guide and Create a service in the AWS Proton User Guide.
        tags(List, optional): Create tags for your service. For more information, see AWS Proton resources and tagging in the AWS Proton Administrator Guide or AWS Proton User Guide. Defaults to None.
        template_major_version(str): The ID of the major version of the service template that was used to create the service.
        template_minor_version(str, optional): The ID of the minor version of the service template that was used to create the service. Defaults to None.
        template_name(str): The name of the service template that's used to create the service.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.init.create(
                ctx, name=value, spec=value, template_major_version=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.init.create name=value, spec=value, template_major_version=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="create_service",
        op_kwargs={
            "branchName": branch_name,
            "description": description,
            "name": name,
            "repositoryConnectionArn": repository_connection_arn,
            "repositoryId": repository_id,
            "spec": spec,
            "tags": tags,
            "templateMajorVersion": template_major_version,
            "templateMinorVersion": template_minor_version,
            "templateName": template_name,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete a service.

    Args:
        name(str): The name of the service to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="proton", operation="delete_service", op_kwargs={"name": name}
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Get detail data for a service.

    Args:
        name(str): The name of the service that you want to get the detail data for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="proton", operation="get_service", op_kwargs={"name": name}
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List services with summaries of detail data.

    Args:
        max_results(int, optional): The maximum number of services to list. Defaults to None.
        next_token(str, optional): A token to indicate the location of the next service in the array of services, after the list of services that was previously requested. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="list_services",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub, ctx, name: str, description: str = None, spec: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Edit a service description or use a spec to add and delete service instances.  Existing service instances and the service pipeline can't be edited using this API. They can only be deleted.  Use the description parameter to modify the description. Edit the spec parameter to add or delete instances.

    Args:
        description(str, optional): The edited service description. Defaults to None.
        name(str): The name of the service to edit.
        spec(str, optional): Lists the service instances to add and the existing service instances to remain. Omit the existing service instances to delete from the list. Don't include edits to the existing service instances or pipeline. For more information, see Edit a service in the AWS Proton Administrator Guide or the AWS Proton User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.service.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.service.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="update_service",
        op_kwargs={"description": description, "name": name, "spec": spec},
    )
