"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    source: Dict,
    template_name: str,
    client_token: str = None,
    description: str = None,
    major_version: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new major or minor version of an environment template. A major version of an environment template is a version that isn't backwards compatible. A minor version of an environment template is a version that's backwards compatible within its major version.

    Args:
        client_token(str, optional): When included, if two identicial requests are made with the same client token, AWS Proton returns the environment template version that the first request created. Defaults to None.
        description(str, optional): A description of the new version of an environment template. Defaults to None.
        major_version(str, optional): To create a new minor version of the environment template, include a majorVersion. To create a new major and minor version of the environment template, exclude majorVersion. Defaults to None.
        source(Dict): An object that includes the template bundle S3 bucket path and name for the new version of an template.
        tags(List, optional): Create tags for a new version of an environment template. Defaults to None.
        template_name(str): The name of the environment template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.version.create(
                ctx, source=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.version.create source=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="create_environment_template_version",
        op_kwargs={
            "clientToken": client_token,
            "description": description,
            "majorVersion": major_version,
            "source": source,
            "tags": tags,
            "templateName": template_name,
        },
    )


async def delete(
    hub, ctx, major_version: str, minor_version: str, template_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    If no other minor versions of an environment template exist, delete a major version of the environment template if it's not the Recommended version. Delete the Recommended version of the environment template if no other major versions or minor versions of the environment template exist. A major version of an environment template is a version that's not backwards compatible. Delete a minor version of an environment template if it isn't the Recommended version. Delete a Recommended minor version of the environment template if no other minor versions of the environment template exist. A minor version of an environment template is a version that's backwards compatible.

    Args:
        major_version(str): The environment template major version to delete.
        minor_version(str): The environment template minor version to delete.
        template_name(str): The name of the environment template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.version.delete(
                ctx, major_version=value, minor_version=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.version.delete major_version=value, minor_version=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="delete_environment_template_version",
        op_kwargs={
            "majorVersion": major_version,
            "minorVersion": minor_version,
            "templateName": template_name,
        },
    )


async def get(
    hub, ctx, major_version: str, minor_version: str, template_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    View detail data for a major or minor version of an environment template.

    Args:
        major_version(str): To view environment template major version detail data, include majorVersion.
        minor_version(str): To view environment template minor version detail data, include minorVersion.
        template_name(str): The name of the environment template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.version.get(
                ctx, major_version=value, minor_version=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.version.get major_version=value, minor_version=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="get_environment_template_version",
        op_kwargs={
            "majorVersion": major_version,
            "minorVersion": minor_version,
            "templateName": template_name,
        },
    )


async def list_all(
    hub,
    ctx,
    template_name: str,
    major_version: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List major or minor versions of an environment template with detail data.

    Args:
        major_version(str, optional): To view a list of minor of versions under a major version of an environment template, include majorVersion. To view a list of major versions of an environment template, exclude majorVersion. Defaults to None.
        max_results(int, optional): The maximum number of major or minor versions of an environment template to list. Defaults to None.
        next_token(str, optional): A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template, after the list of major or minor versions that was previously requested. Defaults to None.
        template_name(str): The name of the environment template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.version.list_all(
                ctx, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.version.list_all template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="list_environment_template_versions",
        op_kwargs={
            "majorVersion": major_version,
            "maxResults": max_results,
            "nextToken": next_token,
            "templateName": template_name,
        },
    )


async def update(
    hub,
    ctx,
    major_version: str,
    minor_version: str,
    template_name: str,
    description: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a major or minor version of an environment template.

    Args:
        description(str, optional): A description of environment template version to update. Defaults to None.
        major_version(str): To update a major version of an environment template, include majorVersion.
        minor_version(str): To update a minor version of an environment template, include minorVersion.
        status(str, optional): The status of the environment template minor version to update. Defaults to None.
        template_name(str): The name of the environment template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.version.update(
                ctx, major_version=value, minor_version=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.version.update major_version=value, minor_version=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="update_environment_template_version",
        op_kwargs={
            "description": description,
            "majorVersion": major_version,
            "minorVersion": minor_version,
            "status": status,
            "templateName": template_name,
        },
    )
