"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    display_name: str = None,
    encryption_key: str = None,
    provisioning: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an environment template for AWS Proton. For more information, see Environment Templates in the AWS Proton Administrator Guide. You can create an environment template in one of the two following ways:   Register and publish a standard environment template that instructs AWS Proton to deploy and manage environment infrastructure.   Register and publish a customer managed environment template that connects AWS Proton to your existing provisioned infrastructure that you manage. AWS Proton doesn't manage your existing provisioned infrastructure. To create an environment template for customer provisioned and managed infrastructure, include the provisioning parameter and set the value to CUSTOMER_MANAGED. For more information, see Register and publish an environment template in the AWS Proton Administrator Guide.

    Args:
        description(str, optional): A description of the environment template. Defaults to None.
        display_name(str, optional): The environment template name as displayed in the developer interface. Defaults to None.
        encryption_key(str, optional): A customer provided encryption key that AWS Proton uses to encrypt data. Defaults to None.
        name(str): The name of the environment template.
        provisioning(str, optional): When included, indicates that the environment template is for customer provisioned and managed infrastructure. Defaults to None.
        tags(List, optional): Create tags for your environment template. For more information, see AWS Proton resources and tagging in the AWS Proton Administrator Guide or AWS Proton User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="create_environment_template",
        op_kwargs={
            "description": description,
            "displayName": display_name,
            "encryptionKey": encryption_key,
            "name": name,
            "provisioning": provisioning,
            "tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    If no other major or minor versions of an environment template exist, delete the environment template.

    Args:
        name(str): The name of the environment template to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="delete_environment_template",
        op_kwargs={"name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Get detail data for an environment template.

    Args:
        name(str): The name of the environment template that you want to get the detail data for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="get_environment_template",
        op_kwargs={"name": name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List environment templates.

    Args:
        max_results(int, optional): The maximum number of environment templates to list. Defaults to None.
        next_token(str, optional): A token to indicate the location of the next environment template in the array of environment templates, after the list of environment templates that was previously requested. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="list_environment_templates",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub, ctx, name: str, description: str = None, display_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Update an environment template.

    Args:
        description(str, optional): A description of the environment template update. Defaults to None.
        display_name(str, optional): The name of the environment template to update as displayed in the developer interface. Defaults to None.
        name(str): The name of the environment template to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.template.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.template.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="update_environment_template",
        op_kwargs={
            "description": description,
            "displayName": display_name,
            "name": name,
        },
    )
