"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    spec: str,
    template_major_version: str,
    template_name: str,
    description: str = None,
    environment_account_connection_id: str = None,
    proton_service_role_arn: str = None,
    tags: List = None,
    template_minor_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deploy a new environment. An AWS Proton environment is created from an environment template that defines infrastructure and resources that can be shared across services. For more information, see the Environments in the AWS Proton Administrator Guide.

    Args:
        description(str, optional): A description of the environment that's being created and deployed. Defaults to None.
        environment_account_connection_id(str, optional): The ID of the environment account connection that you provide if you're provisioning your environment infrastructure resources to an environment account. You must include either the environmentAccountConnectionId or protonServiceRoleArn parameter and value. For more information, see Environment account connections in the AWS Proton Administrator guide. Defaults to None.
        name(str): The name of the environment.
        proton_service_role_arn(str, optional): The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS Proton to make calls to other services on your behalf. You must include either the environmentAccountConnectionId or protonServiceRoleArn parameter and value. Defaults to None.
        spec(str): A link to a YAML formatted spec file that provides inputs as defined in the environment template bundle schema file. For more information, see Environments in the AWS Proton Administrator Guide.
        tags(List, optional): Create tags for your environment. For more information, see AWS Proton resources and tagging in the AWS Proton Administrator Guide or AWS Proton User Guide. Defaults to None.
        template_major_version(str): The ID of the major version of the environment template.
        template_minor_version(str, optional): The ID of the minor version of the environment template. Defaults to None.
        template_name(str): The name of the environment template. For more information, see Environment Templates in the AWS Proton Administrator Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.init.create(
                ctx, name=value, spec=value, template_major_version=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.init.create name=value, spec=value, template_major_version=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="create_environment",
        op_kwargs={
            "description": description,
            "environmentAccountConnectionId": environment_account_connection_id,
            "name": name,
            "protonServiceRoleArn": proton_service_role_arn,
            "spec": spec,
            "tags": tags,
            "templateMajorVersion": template_major_version,
            "templateMinorVersion": template_minor_version,
            "templateName": template_name,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an environment.

    Args:
        name(str): The name of the environment to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="delete_environment",
        op_kwargs={"name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Get detail data for an environment.

    Args:
        name(str): The name of the environment that you want to get the detail data for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="get_environment",
        op_kwargs={"name": name},
    )


async def list_all(
    hub,
    ctx,
    environment_templates: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List environments with detail data summaries.

    Args:
        environment_templates(List, optional): An array of the versions of the environment template. Defaults to None.
        max_results(int, optional): The maximum number of environments to list. Defaults to None.
        next_token(str, optional): A token to indicate the location of the next environment in the array of environments, after the list of environments that was previously requested. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="list_environments",
        op_kwargs={
            "environmentTemplates": environment_templates,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    deployment_type: str,
    name: str,
    description: str = None,
    environment_account_connection_id: str = None,
    proton_service_role_arn: str = None,
    spec: str = None,
    template_major_version: str = None,
    template_minor_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update an environment. If the environment is associated with an environment account connection, don't update or include the protonServiceRoleArn parameter to update or connect to an environment account connection.  You can only update to a new environment account connection if it was created in the same environment account that the current environment account connection was created in and is associated with the current environment. If the environment isn't associated with an environment account connection, don't update or include the environmentAccountConnectionId parameter to update or connect to an environment account connection. You can update either the environmentAccountConnectionId or protonServiceRoleArn parameter and value. You can’t update both. There are four modes for updating an environment as described in the following. The deploymentType field defines the mode.     NONE  In this mode, a deployment doesn't occur. Only the requested metadata parameters are updated.     CURRENT_VERSION  In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated. Don’t include minor or major version parameters when you use this deployment-type.     MINOR_VERSION  In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.     MAJOR_VERSION  In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that's higher than the major version in use and a minor version (optional).

    Args:
        deployment_type(str): There are four modes for updating an environment as described in the following. The deploymentType field defines the mode.     NONE  In this mode, a deployment doesn't occur. Only the requested metadata parameters are updated.     CURRENT_VERSION  In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated. Don’t include minor or major version parameters when you use this deployment-type.     MINOR_VERSION  In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.     MAJOR_VERSION  In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that is higher than the major version in use and a minor version (optional).  .
        description(str, optional): A description of the environment update. Defaults to None.
        environment_account_connection_id(str, optional): The ID of the environment account connection. You can only update to a new environment account connection if it was created in the same environment account that the current environment account connection was created in and is associated with the current environment. Defaults to None.
        name(str): The name of the environment to update.
        proton_service_role_arn(str, optional): The Amazon Resource Name (ARN) of the AWS Proton service role that allows AWS Proton to make API calls to other services your behalf. Defaults to None.
        spec(str, optional): The formatted specification that defines the update. Defaults to None.
        template_major_version(str, optional): The ID of the major version of the environment to update. Defaults to None.
        template_minor_version(str, optional): The ID of the minor version of the environment to update. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.init.update(
                ctx, deployment_type=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.init.update deployment_type=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="update_environment",
        op_kwargs={
            "deploymentType": deployment_type,
            "description": description,
            "environmentAccountConnectionId": environment_account_connection_id,
            "name": name,
            "protonServiceRoleArn": proton_service_role_arn,
            "spec": spec,
            "templateMajorVersion": template_major_version,
            "templateMinorVersion": template_minor_version,
        },
    )
