"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, environment_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Attempts to cancel an environment deployment on an UpdateEnvironment action, if the deployment is IN_PROGRESS. For more information, see Update an environment in the AWS Proton Administrator guide. The following list includes potential cancellation scenarios.   If the cancellation attempt succeeds, the resulting deployment state is CANCELLED.   If the cancellation attempt fails, the resulting deployment state is FAILED.   If the current UpdateEnvironment action succeeds before the cancellation attempt starts, the resulting deployment state is SUCCEEDED and the cancellation attempt has no effect.

    Args:
        environment_name(str): The name of the environment with the deployment to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.deployment.cancel(
                ctx, environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.deployment.cancel environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="cancel_environment_deployment",
        op_kwargs={"environmentName": environment_name},
    )
