"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    In a management account, an environment account connection request is accepted. When the environment account connection request is accepted, AWS Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account. For more information, see Environment account connections in the AWS Proton Administrator guide.

    Args:
        id_(str): The ID of the environment account connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.account_connection.accept(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.account_connection.accept id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="accept_environment_account_connection",
        op_kwargs={"id": id_},
    )


async def create(
    hub,
    ctx,
    environment_name: str,
    management_account_id: str,
    role_arn: str,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an environment account connection in an environment account so that environment infrastructure resources can be provisioned in the environment account from a management account. An environment account connection is a secure bi-directional connection between a management account and an environment account that maintains authorization and permissions. For more information, see Environment account connections in the AWS Proton Administrator guide.

    Args:
        client_token(str, optional): When included, if two identicial requests are made with the same client token, AWS Proton returns the environment account connection that the first request created. Defaults to None.
        environment_name(str): The name of the AWS Proton environment that's created in the associated management account.
        management_account_id(str): The ID of the management account that accepts or rejects the environment account connection. You create an manage the AWS Proton environment in this account. If the management account accepts the environment account connection, AWS Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. AWS Proton uses this role to provision infrastructure resources in the associated environment account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.account_connection.create(
                ctx, environment_name=value, management_account_id=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.account_connection.create environment_name=value, management_account_id=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="create_environment_account_connection",
        op_kwargs={
            "clientToken": client_token,
            "environmentName": environment_name,
            "managementAccountId": management_account_id,
            "roleArn": role_arn,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    In an environment account, delete an environment account connection. After you delete an environment account connection that’s in use by an AWS Proton environment, AWS Proton can’t manage the environment infrastructure resources until a new environment account connection is accepted for the environment account and associated environment. You're responsible for cleaning up provisioned resources that remain without an environment connection. For more information, see Environment account connections in the AWS Proton Administrator guide.

    Args:
        id_(str): The ID of the environment account connection to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.account_connection.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.account_connection.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="delete_environment_account_connection",
        op_kwargs={"id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    In an environment account, view the detail data for an environment account connection. For more information, see Environment account connections in the AWS Proton Administrator guide.

    Args:
        id_(str): The ID of the environment account connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.account_connection.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.account_connection.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="get_environment_account_connection",
        op_kwargs={"id": id_},
    )


async def list_all(
    hub,
    ctx,
    requested_by: str,
    environment_name: str = None,
    max_results: int = None,
    next_token: str = None,
    statuses: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    View a list of environment account connections. For more information, see Environment account connections in the AWS Proton Administrator guide.

    Args:
        environment_name(str, optional): The environment name that's associated with each listed environment account connection. Defaults to None.
        max_results(int, optional): The maximum number of environment account connections to list. Defaults to None.
        next_token(str, optional): A token to indicate the location of the next environment account connection in the array of environment account connections, after the list of environment account connections that was previously requested. Defaults to None.
        requested_by(str): The type of account making the ListEnvironmentAccountConnections request.
        statuses(List, optional): The status details for each listed environment account connection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.account_connection.list_all(
                ctx, requested_by=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.account_connection.list_all requested_by=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="list_environment_account_connections",
        op_kwargs={
            "environmentName": environment_name,
            "maxResults": max_results,
            "nextToken": next_token,
            "requestedBy": requested_by,
            "statuses": statuses,
        },
    )


async def reject(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    In a management account, reject an environment account connection from another environment account. After you reject an environment account connection request, you won’t be able to accept or use the rejected environment account connection. You can’t reject an environment account connection that is connected to an environment. For more information, see Environment account connections in the AWS Proton Administrator guide.

    Args:
        id_(str): The ID of the environment account connection to reject.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.account_connection.reject(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.account_connection.reject id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="reject_environment_account_connection",
        op_kwargs={"id": id_},
    )


async def update(hub, ctx, id_: str, role_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    In an environment account, update an environment account connection to use a new IAM role. For more information, see Environment account connections in the AWS Proton Administrator guide.

    Args:
        id_(str): The ID of the environment account connection to update.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM service role that is associated with the environment account connection to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.environment.account_connection.update(
                ctx, id_=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.environment.account_connection.update id_=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="update_environment_account_connection",
        op_kwargs={"id": id_, "roleArn": role_arn},
    )
