"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Get detail data for the AWS Proton pipeline service role.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.account_setting.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.account_setting.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="proton", operation="get_account_settings", op_kwargs={}
    )


async def update_multiple(hub, ctx, pipeline_service_role_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Update the AWS Proton pipeline service account settings.

    Args:
        pipeline_service_role_arn(str, optional): The Amazon Resource Name (ARN) of the AWS Proton pipeline service role. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.proton.account_setting.update_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.proton.account_setting.update_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="proton",
        operation="update_account_settings",
        op_kwargs={"pipelineServiceRoleArn": pipeline_service_role_arn},
    )
