"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    service_code: str = None,
    format_version: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the metadata for one service or a list of the metadata for all services. Use this without a service code to get the service codes for all services. Use it with a service code, such as AmazonEC2, to get information specific to that service, such as the attribute names available for that service. For example, some of the attribute names available for EC2 are volumeType, maxIopsVolume, operation, locationType, and instanceCapacity10xlarge.

    Args:
        service_code(str, optional): The code for the service whose information you want to retrieve, such as AmazonEC2. You can use the ServiceCode to filter the results in a GetProducts call. To retrieve a list of all services, leave this blank. Defaults to None.
        format_version(str, optional): The format version that you want the response to be in. Valid values are: aws_v1 . Defaults to None.
        next_token(str, optional): The pagination token that indicates the next set of results that you want to retrieve. Defaults to None.
        max_results(int, optional): The maximum number of results that you want returned in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pricing.service.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pricing.service.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pricing",
        operation="describe_services",
        op_kwargs={
            "ServiceCode": service_code,
            "FormatVersion": format_version,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
