"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    service_code: str,
    attribute_name: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of attribute values. Attibutes are similar to the details in a Price List API offer file. For a list of available attributes, see Offer File Definitions in the Amazon Web Services Billing and Cost Management User Guide.

    Args:
        service_code(str): The service code for the service whose attributes you want to retrieve. For example, if you want the retrieve an EC2 attribute, use AmazonEC2.
        attribute_name(str): The name of the attribute that you want to retrieve the values for, such as volumeType.
        next_token(str, optional): The pagination token that indicates the next set of results that you want to retrieve. Defaults to None.
        max_results(int, optional): The maximum number of results to return in response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pricing.attribute_value.get_all(
                ctx, service_code=value, attribute_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pricing.attribute_value.get_all service_code=value, attribute_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pricing",
        operation="get_attribute_values",
        op_kwargs={
            "ServiceCode": service_code,
            "AttributeName": attribute_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
