"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    engine: str = None,
    language_code: str = None,
    include_additional_language_codes: bool = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of voices that are available for use when requesting speech synthesis. Each voice speaks a specified language, is either male or female, and is identified by an ID, which is the ASCII version of the voice name.  When synthesizing speech ( SynthesizeSpeech ), you provide the voice ID for the voice you want from the list of voices returned by DescribeVoices. For example, you want your news reader application to read news in a specific language, but giving a user the option to choose the voice. Using the DescribeVoices operation you can provide the user with a list of available voices to select from.  You can optionally specify a language code to filter the available voices. For example, if you specify en-US, the operation returns a list of all available US English voices.  This operation requires permissions to perform the polly:DescribeVoices action.

    Args:
        engine(str, optional): Specifies the engine (standard or neural) used by Amazon Polly when processing input text for speech synthesis. . Defaults to None.
        language_code(str, optional):  The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list of voices returned. If you don't specify this optional parameter, all available voices are returned. . Defaults to None.
        include_additional_language_codes(bool, optional): Boolean value indicating whether to return any bilingual voices that use the specified language as an additional language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify yes but not if you specify no. Defaults to None.
        next_token(str, optional): An opaque pagination token returned from the previous DescribeVoices operation. If present, this indicates where to continue the listing. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.polly.voice.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.polly.voice.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="polly",
        operation="describe_voices",
        op_kwargs={
            "Engine": engine,
            "LanguageCode": language_code,
            "IncludeAdditionalLanguageCodes": include_additional_language_codes,
            "NextToken": next_token,
        },
    )
