"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def synthesize(
    hub,
    ctx,
    output_format: str,
    text: str,
    voice_id: str,
    engine: str = None,
    language_code: str = None,
    lexicon_names: List = None,
    sample_rate: str = None,
    speech_mark_types: List = None,
    text_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML. Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by English voices) unless phoneme mapping is used. For more information, see How it Works.

    Args:
        engine(str, optional): Specifies the engine (standard or neural) for Amazon Polly to use when processing input text for speech synthesis. For information on Amazon Polly voices and which voices are available in standard-only, NTTS-only, and both standard and NTTS formats, see Available Voices.  NTTS-only voices  When using NTTS-only voices such as Kevin (en-US), this parameter is required and must be set to neural. If the engine is not specified, or is set to standard, this will result in an error.  Type: String Valid Values: standard | neural  Required: Yes  Standard voices  For standard voices, this is not required; the engine parameter defaults to standard. If the engine is not specified, or is set to standard and an NTTS-only voice is selected, this will result in an error. . Defaults to None.
        language_code(str, optional): Optional language code for the Synthesize Speech request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).  If a bilingual voice is used and no language code is specified, Amazon Polly will use the default language of the bilingual voice. The default language for any voice is the one returned by the DescribeVoices operation for the LanguageCode parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi. Defaults to None.
        lexicon_names(List, optional): List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. For information about storing lexicons, see PutLexicon. Defaults to None.
        output_format(str):  The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.  When pcm is used, the content returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format. .
        sample_rate(str, optional): The audio frequency specified in Hz. The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". Valid values for pcm are "8000" and "16000" The default value is "16000". . Defaults to None.
        speech_mark_types(List, optional): The type of speech marks returned for the input text. Defaults to None.
        text(str):  Input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text. .
        text_type(str, optional):  Specifies whether the input text is plain text or SSML. The default value is plain text. For more information, see Using SSML. Defaults to None.
        voice_id(str):  Voice ID to use for the synthesis. You can get a list of available voice IDs by calling the DescribeVoices operation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.polly.speech.init.synthesize(
                ctx, output_format=value, text=value, voice_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.polly.speech.init.synthesize output_format=value, text=value, voice_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="polly",
        operation="synthesize_speech",
        op_kwargs={
            "Engine": engine,
            "LanguageCode": language_code,
            "LexiconNames": lexicon_names,
            "OutputFormat": output_format,
            "SampleRate": sample_rate,
            "SpeechMarkTypes": speech_mark_types,
            "Text": text,
            "TextType": text_type,
            "VoiceId": voice_id,
        },
    )
