"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified pronunciation lexicon stored in an AWS Region. A lexicon which has been deleted is not available for speech synthesis, nor is it possible to retrieve it using either the GetLexicon or ListLexicon APIs. For more information, see Managing Lexicons.

    Args:
        name(str): The name of the lexicon to delete. Must be an existing lexicon in the region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.polly.lexicon.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.polly.lexicon.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="polly", operation="delete_lexicon", op_kwargs={"Name": name}
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the content of the specified pronunciation lexicon stored in an AWS Region. For more information, see Managing Lexicons.

    Args:
        name(str): Name of the lexicon.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.polly.lexicon.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.polly.lexicon.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="polly", operation="get_lexicon", op_kwargs={"Name": name}
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of pronunciation lexicons stored in an AWS Region. For more information, see Managing Lexicons.

    Args:
        next_token(str, optional): An opaque pagination token returned from previous ListLexicons operation. If present, indicates where to continue the list of lexicons. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.polly.lexicon.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.polly.lexicon.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="polly",
        operation="list_lexicons",
        op_kwargs={"NextToken": next_token},
    )


async def put(hub, ctx, name: str, content: str) -> Dict:
    r"""
    **Autogenerated function**

    Stores a pronunciation lexicon in an AWS Region. If a lexicon with the same name already exists in the region, it is overwritten by the new lexicon. Lexicon operations have eventual consistency, therefore, it might take some time before the lexicon is available to the SynthesizeSpeech operation. For more information, see Managing Lexicons.

    Args:
        name(str): Name of the lexicon. The name must follow the regular express format [0-9A-Za-z]{1,20}. That is, the name is a case-sensitive alphanumeric string up to 20 characters long. .
        content(str): Content of the PLS lexicon as string data.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.polly.lexicon.put(ctx, name=value, content=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.polly.lexicon.put name=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="polly",
        operation="put_lexicon",
        op_kwargs={"Name": name, "Content": content},
    )
