"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub,
    ctx,
    caller_id: str = None,
    configuration_set_name: str = None,
    content: Dict = None,
    destination_phone_number: str = None,
    origination_phone_number: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new voice message and send it to a recipient's phone number.

    Args:
        caller_id(str, optional): The phone number that appears on recipients' devices when they receive the message. Defaults to None.
        configuration_set_name(str, optional): The name of the configuration set that you want to use to send the message. Defaults to None.
        content(Dict, optional): An object that contains a voice message and information about the recipient that you want to send it to. Defaults to None.
        destination_phone_number(str, optional): The phone number that you want to send the voice message to. Defaults to None.
        origination_phone_number(str, optional): The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone number that appears on recipients' devices when they receive the message, because you can specify a CallerId parameter in the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_sms_voice.voice_message.send(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_sms_voice.voice_message.send
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-sms-voice",
        operation="send_voice_message",
        op_kwargs={
            "CallerId": caller_id,
            "ConfigurationSetName": configuration_set_name,
            "Content": content,
            "DestinationPhoneNumber": destination_phone_number,
            "OriginationPhoneNumber": origination_phone_number,
        },
    )
