"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, configuration_set_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Create a new configuration set. After you create the configuration set, you can add one or more event destinations to it.

    Args:
        configuration_set_name(str, optional): The name that you want to give the configuration set. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_sms_voice.configuration_set_.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_sms_voice.configuration_set_.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-sms-voice",
        operation="create_configuration_set",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )


async def delete(hub, ctx, configuration_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing configuration set.

    Args:
        configuration_set_name(str): ConfigurationSetName.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_sms_voice.configuration_set_.init.delete(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_sms_voice.configuration_set_.init.delete configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-sms-voice",
        operation="delete_configuration_set",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )
