"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    configuration_set_name: str,
    event_destination: Dict = None,
    event_destination_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new event destination in a configuration set.

    Args:
        configuration_set_name(str): ConfigurationSetName.
        event_destination(Dict, optional): An object that defines a single event destination. Defaults to None.
        event_destination_name(str, optional): A name that identifies the event destination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_sms_voice.configuration_set_.event_destination.create(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_sms_voice.configuration_set_.event_destination.create configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-sms-voice",
        operation="create_configuration_set_event_destination",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "EventDestination": event_destination,
            "EventDestinationName": event_destination_name,
        },
    )


async def delete(
    hub, ctx, configuration_set_name: str, event_destination_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an event destination in a configuration set.

    Args:
        configuration_set_name(str): ConfigurationSetName.
        event_destination_name(str): EventDestinationName.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_sms_voice.configuration_set_.event_destination.delete(
                ctx, configuration_set_name=value, event_destination_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_sms_voice.configuration_set_.event_destination.delete configuration_set_name=value, event_destination_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-sms-voice",
        operation="delete_configuration_set_event_destination",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "EventDestinationName": event_destination_name,
        },
    )


async def get_all(hub, ctx, configuration_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name (ARN) of the destination, and the name of the event destination.

    Args:
        configuration_set_name(str): ConfigurationSetName.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_sms_voice.configuration_set_.event_destination.get_all(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_sms_voice.configuration_set_.event_destination.get_all configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-sms-voice",
        operation="get_configuration_set_event_destinations",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )


async def update(
    hub,
    ctx,
    configuration_set_name: str,
    event_destination_name: str,
    event_destination: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update an event destination in a configuration set. An event destination is a location that you publish information about your voice calls to. For example, you can log an event to an Amazon CloudWatch destination when a call fails.

    Args:
        configuration_set_name(str): ConfigurationSetName.
        event_destination(Dict, optional): An object that defines a single event destination. Defaults to None.
        event_destination_name(str): EventDestinationName.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_sms_voice.configuration_set_.event_destination.update(
                ctx, configuration_set_name=value, event_destination_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_sms_voice.configuration_set_.event_destination.update configuration_set_name=value, event_destination_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-sms-voice",
        operation="update_configuration_set_event_destination",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "EventDestination": event_destination,
            "EventDestinationName": event_destination_name,
        },
    )
