"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def send(
    hub,
    ctx,
    destination: Dict,
    content: Dict,
    from_email_address: str = None,
    reply_to_addresses: List = None,
    feedback_forwarding_email_address: str = None,
    email_tags: List = None,
    configuration_set_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sends an email message. You can use the Amazon Pinpoint Email API to send two types of messages:    Simple – A standard email message. When you create this type of message, you specify the sender, the recipient, and the message body, and Amazon Pinpoint assembles the message for you.    Raw – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of the message headers, as well as the message body. You can use this message type to send messages that contain attachments. The message that you specify has to be a valid MIME message.

    Args:
        from_email_address(str, optional): The email address that you want to use as the "From" address for the email. The address that you specify has to be verified. . Defaults to None.
        destination(Dict): An object that contains the recipients of the email message.
        reply_to_addresses(List, optional): The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply. Defaults to None.
        feedback_forwarding_email_address(str, optional): The address that Amazon Pinpoint should send bounce and complaint notifications to. Defaults to None.
        content(Dict): An object that contains the body of the message. You can send either a Simple message or a Raw message.
        email_tags(List, optional): A list of tags, in the form of name/value pairs, to apply to an email that you send using the SendEmail operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. . Defaults to None.
        configuration_set_name(str, optional): The name of the configuration set that you want to use when sending the email. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.email.init.send(
                ctx, destination=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.email.init.send destination=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="send_email",
        op_kwargs={
            "FromEmailAddress": from_email_address,
            "Destination": destination,
            "ReplyToAddresses": reply_to_addresses,
            "FeedbackForwardingEmailAddress": feedback_forwarding_email_address,
            "Content": content,
            "EmailTags": email_tags,
            "ConfigurationSetName": configuration_set_name,
        },
    )
