"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, email_identity: str, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Verifies an email identity for use with Amazon Pinpoint. In Amazon Pinpoint, an identity is an email address or domain that you use when you send email. Before you can use an identity to send email with Amazon Pinpoint, you first have to verify it. By verifying an address, you demonstrate that you're the owner of the address, and that you've given Amazon Pinpoint permission to send email from the address. When you verify an email address, Amazon Pinpoint sends an email to the address. Your email address is verified as soon as you follow the link in the verification email.  When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon Pinpoint detects these records in the DNS configuration for your domain. It usually takes around 72 hours to complete the domain verification process.

    Args:
        email_identity(str): The email address or domain that you want to verify.
        tags(List, optional): An array of objects that define the tags (keys and values) that you want to associate with the email identity. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.email.identity.init.create(
                ctx, email_identity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.email.identity.init.create email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="create_email_identity",
        op_kwargs={"EmailIdentity": email_identity, "Tags": tags},
    )


async def delete(hub, ctx, email_identity: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an email identity that you previously verified for use with Amazon Pinpoint. An identity can be either an email address or a domain name.

    Args:
        email_identity(str): The identity (that is, the email address or domain) that you want to delete from your Amazon Pinpoint account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.email.identity.init.delete(
                ctx, email_identity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.email.identity.init.delete email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="delete_email_identity",
        op_kwargs={"EmailIdentity": email_identity},
    )


async def get(hub, ctx, email_identity: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about a specific identity associated with your Amazon Pinpoint account, including the identity's verification status, its DKIM authentication status, and its custom Mail-From settings.

    Args:
        email_identity(str): The email identity that you want to retrieve details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.email.identity.init.get(
                ctx, email_identity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.email.identity.init.get email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="get_email_identity",
        op_kwargs={"EmailIdentity": email_identity},
    )


async def list_all(hub, ctx, next_token: str = None, page_size: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all of the email identities that are associated with your Amazon Pinpoint account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't.

    Args:
        next_token(str, optional): A token returned from a previous call to ListEmailIdentities to indicate the position in the list of identities. Defaults to None.
        page_size(int, optional): The number of results to show in a single call to ListEmailIdentities. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results. The value you specify has to be at least 0, and can be no more than 1000. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.email.identity.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.email.identity.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="list_email_identities",
        op_kwargs={"NextToken": next_token, "PageSize": page_size},
    )
