"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, pool_name: str, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Pinpoint account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, Amazon Pinpoint sends it using only the IP addresses in the associated pool.

    Args:
        pool_name(str): The name of the dedicated IP pool.
        tags(List, optional): An object that defines the tags (keys and values) that you want to associate with the pool. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.dedicated_ip.pool.create(ctx, pool_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.dedicated_ip.pool.create pool_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="create_dedicated_ip_pool",
        op_kwargs={"PoolName": pool_name, "Tags": tags},
    )


async def delete(hub, ctx, pool_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete a dedicated IP pool.

    Args:
        pool_name(str): The name of the dedicated IP pool that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.dedicated_ip.pool.delete(ctx, pool_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.dedicated_ip.pool.delete pool_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="delete_dedicated_ip_pool",
        op_kwargs={"PoolName": pool_name},
    )


async def list_all(hub, ctx, next_token: str = None, page_size: int = None) -> Dict:
    r"""
    **Autogenerated function**

    List all of the dedicated IP pools that exist in your Amazon Pinpoint account in the current AWS Region.

    Args:
        next_token(str, optional): A token returned from a previous call to ListDedicatedIpPools to indicate the position in the list of dedicated IP pools. Defaults to None.
        page_size(int, optional): The number of results to show in a single call to ListDedicatedIpPools. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.dedicated_ip.pool.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.dedicated_ip.pool.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="list_dedicated_ip_pools",
        op_kwargs={"NextToken": next_token, "PageSize": page_size},
    )
