"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, ip: str) -> Dict:
    r"""
    **Autogenerated function**

    Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.

    Args:
        ip(str): The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Pinpoint account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.dedicated_ip.init.get(ctx, ip=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.dedicated_ip.init.get ip=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="get_dedicated_ip",
        op_kwargs={"Ip": ip},
    )


async def get_all(
    hub, ctx, pool_name: str = None, next_token: str = None, page_size: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the dedicated IP addresses that are associated with your Amazon Pinpoint account.

    Args:
        pool_name(str, optional): The name of the IP pool that the dedicated IP address is associated with. Defaults to None.
        next_token(str, optional): A token returned from a previous call to GetDedicatedIps to indicate the position of the dedicated IP pool in the list of IP pools. Defaults to None.
        page_size(int, optional): The number of results to show in a single call to GetDedicatedIpsRequest. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.dedicated_ip.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.dedicated_ip.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="get_dedicated_ips",
        op_kwargs={
            "PoolName": pool_name,
            "NextToken": next_token,
            "PageSize": page_size,
        },
    )
