"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(
    hub, ctx, configuration_set_name: str, custom_redirect_domain: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Specify a custom domain to use for open and click tracking elements in email that you send using Amazon Pinpoint.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to add a custom tracking domain to.
        custom_redirect_domain(str, optional): The domain that you want to use to track open and click events. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.configuration_set_.tracking_option.put_multiple(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.configuration_set_.tracking_option.put_multiple configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="put_configuration_set_tracking_options",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "CustomRedirectDomain": custom_redirect_domain,
        },
    )
