"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(
    hub, ctx, configuration_set_name: str, reputation_metrics_enabled: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific AWS Region.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to enable or disable reputation metric tracking for.
        reputation_metrics_enabled(bool, optional): If true, tracking of reputation metrics is enabled for the configuration set. If false, tracking of reputation metrics is disabled for the configuration set. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.configuration_set_.reputation_option.put_multiple(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.configuration_set_.reputation_option.put_multiple configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="put_configuration_set_reputation_options",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "ReputationMetricsEnabled": reputation_metrics_enabled,
        },
    )
