"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    configuration_set_name: str,
    tracking_options: Dict = None,
    delivery_options: Dict = None,
    reputation_options: Dict = None,
    sending_options: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a configuration set. Configuration sets are groups of rules that you can apply to the emails you send using Amazon Pinpoint. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.

    Args:
        configuration_set_name(str): The name of the configuration set.
        tracking_options(Dict, optional): An object that defines the open and click tracking options for emails that you send using the configuration set. Defaults to None.
        delivery_options(Dict, optional): An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set. Defaults to None.
        reputation_options(Dict, optional): An object that defines whether or not Amazon Pinpoint collects reputation metrics for the emails that you send that use the configuration set. Defaults to None.
        sending_options(Dict, optional): An object that defines whether or not Amazon Pinpoint can send email that you send using the configuration set. Defaults to None.
        tags(List, optional): An array of objects that define the tags (keys and values) that you want to associate with the configuration set. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.configuration_set_.init.create(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.configuration_set_.init.create configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="create_configuration_set",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "TrackingOptions": tracking_options,
            "DeliveryOptions": delivery_options,
            "ReputationOptions": reputation_options,
            "SendingOptions": sending_options,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, configuration_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an existing configuration set. In Amazon Pinpoint, configuration sets are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.configuration_set_.init.delete(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.configuration_set_.init.delete configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="delete_configuration_set",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )


async def get(hub, ctx, configuration_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more. In Amazon Pinpoint, configuration sets are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to obtain more information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.configuration_set_.init.get(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.configuration_set_.init.get configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="get_configuration_set",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )


async def list_all(hub, ctx, next_token: str = None, page_size: int = None) -> Dict:
    r"""
    **Autogenerated function**

    List all of the configuration sets associated with your Amazon Pinpoint account in the current region. In Amazon Pinpoint, configuration sets are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.

    Args:
        next_token(str, optional): A token returned from a previous call to ListConfigurationSets to indicate the position in the list of configuration sets. Defaults to None.
        page_size(int, optional): The number of results to show in a single call to ListConfigurationSets. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.configuration_set_.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.configuration_set_.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="list_configuration_sets",
        op_kwargs={"NextToken": next_token, "PageSize": page_size},
    )
