"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(
    hub,
    ctx,
    configuration_set_name: str,
    tls_policy: str = None,
    sending_pool_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to associate with a dedicated IP pool.
        tls_policy(str, optional): Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is Require, messages are only delivered if a TLS connection can be established. If the value is Optional, messages can be delivered in plain text if a TLS connection can't be established. Defaults to None.
        sending_pool_name(str, optional): The name of the dedicated IP pool that you want to associate with the configuration set. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.configuration_set_.delivery_option.put_multiple(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.configuration_set_.delivery_option.put_multiple configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="put_configuration_set_delivery_options",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "TlsPolicy": tls_policy,
            "SendingPoolName": sending_pool_name,
        },
    )
