"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Obtain information about the email-sending status and capabilities of your Amazon Pinpoint account in the current AWS Region.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.account.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.account.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="pinpoint-email", operation="get_account", op_kwargs={}
    )
