"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(hub, ctx, auto_warmup_enabled: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Enable or disable the automatic warm-up feature for dedicated IP addresses.

    Args:
        auto_warmup_enabled(bool, optional): Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon Pinpoint account in the current AWS Region. Set to true to enable the automatic warm-up feature, or set to false to disable it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint_email.account.dedicated_ip_warmup_attribute.put_multiple(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint_email.account.dedicated_ip_warmup_attribute.put_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint-email",
        operation="put_account_dedicated_ip_warmup_attributes",
        op_kwargs={"AutoWarmupEnabled": auto_warmup_enabled},
    )
