"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(hub, ctx, application_id: str, send_users_message_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates and sends a message to a list of users.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        send_users_message_request(Dict): Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.user.message.send(
                ctx, application_id=value, send_users_message_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.user.message.send application_id=value, send_users_message_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="send_users_messages",
        op_kwargs={
            "ApplicationId": application_id,
            "SendUsersMessageRequest": send_users_message_request,
        },
    )
