"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete_multiple(hub, ctx, application_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes all the endpoints that are associated with a specific user ID.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        user_id(str): The unique identifier for the user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.user.endpoint.delete_multiple(
                ctx, application_id=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.user.endpoint.delete_multiple application_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="delete_user_endpoints",
        op_kwargs={"ApplicationId": application_id, "UserId": user_id},
    )


async def get_all(hub, ctx, application_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about all the endpoints that are associated with a specific user ID.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        user_id(str): The unique identifier for the user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.user.endpoint.get_all(
                ctx, application_id=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.user.endpoint.get_all application_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_user_endpoints",
        op_kwargs={"ApplicationId": application_id, "UserId": user_id},
    )
