"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    template_name: str,
    template_type: str,
    next_token: str = None,
    page_size: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about all the versions of a specific message template.

    Args:
        next_token(str, optional): The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        template_name(str): The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.
        template_type(str): The type of channel that the message template is designed for. Valid values are: EMAIL, PUSH, SMS, and VOICE.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.template.version.list_all(
                ctx, template_name=value, template_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.template.version.list_all template_name=value, template_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="list_template_versions",
        op_kwargs={
            "NextToken": next_token,
            "PageSize": page_size,
            "TemplateName": template_name,
            "TemplateType": template_type,
        },
    )
