"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    page_size: str = None,
    prefix: str = None,
    template_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.

    Args:
        next_token(str, optional): The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        prefix(str, optional): The substring to match in the names of the message templates to include in the results. If you specify this value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify. Defaults to None.
        template_type(str, optional): The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in the results, don't include this parameter in your request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.template.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.template.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="list_templates",
        op_kwargs={
            "NextToken": next_token,
            "PageSize": page_size,
            "Prefix": prefix,
            "TemplateType": template_type,
        },
    )
