"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, sms_template_request: Dict, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a message template for messages that are sent through the SMS channel.

    Args:
        sms_template_request(Dict): Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.
        template_name(str): The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.sms.template.create(
                ctx, sms_template_request=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.sms.template.create sms_template_request=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="create_sms_template",
        op_kwargs={
            "SMSTemplateRequest": sms_template_request,
            "TemplateName": template_name,
        },
    )


async def delete(hub, ctx, template_name: str, version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a message template for messages that were sent through the SMS channel.

    Args:
        template_name(str): The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.
        version(str, optional): The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the Template Versions resource. If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur. If you don't specify a value for this parameter, Amazon Pinpoint does the following: For a get operation, retrieves information about the active version of the template. For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false. For a delete operation, deletes the template, including all versions of the template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.sms.template.delete(ctx, template_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.sms.template.delete template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="delete_sms_template",
        op_kwargs={"TemplateName": template_name, "Version": version},
    )


async def get(hub, ctx, template_name: str, version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the content and settings of a message template for messages that are sent through the SMS channel.

    Args:
        template_name(str): The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.
        version(str, optional): The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the Template Versions resource. If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur. If you don't specify a value for this parameter, Amazon Pinpoint does the following: For a get operation, retrieves information about the active version of the template. For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false. For a delete operation, deletes the template, including all versions of the template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.sms.template.get(ctx, template_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.sms.template.get template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_sms_template",
        op_kwargs={"TemplateName": template_name, "Version": version},
    )


async def update(
    hub,
    ctx,
    sms_template_request: Dict,
    template_name: str,
    create_new_version: bool = None,
    version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing message template for messages that are sent through the SMS channel.

    Args:
        create_new_version(bool, optional): Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the template. If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest existing version of the template. If you specify a value of true for this parameter, don't specify a value for the version parameter. Otherwise, an error will occur. Defaults to None.
        sms_template_request(Dict): Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.
        template_name(str): The name of the message template. A template name must start with an alphanumeric character and can contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.
        version(str, optional): The unique identifier for the version of the message template to update, retrieve information about, or delete. To retrieve identifiers and other information for all the versions of a template, use the Template Versions resource. If specified, this value must match the identifier for an existing template version. If specified for an update operation, this value must match the identifier for the latest existing version of the template. This restriction helps ensure that race conditions don't occur. If you don't specify a value for this parameter, Amazon Pinpoint does the following: For a get operation, retrieves information about the active version of the template. For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the create-new-version parameter isn't used or is set to false. For a delete operation, deletes the template, including all versions of the template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.sms.template.update(
                ctx, sms_template_request=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.sms.template.update sms_template_request=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="update_sms_template",
        op_kwargs={
            "CreateNewVersion": create_new_version,
            "SMSTemplateRequest": sms_template_request,
            "TemplateName": template_name,
            "Version": version,
        },
    )
