"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, application_id: str, segment_id: str, version: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that's associated with an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        segment_id(str): The unique identifier for the segment.
        version(str): The unique version number (Version property) for the campaign version.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.segment.version.get(
                ctx, application_id=value, segment_id=value, version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.segment.version.get application_id=value, segment_id=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_segment_version",
        op_kwargs={
            "ApplicationId": application_id,
            "SegmentId": segment_id,
            "Version": version,
        },
    )


async def get_all(
    hub,
    ctx,
    application_id: str,
    segment_id: str,
    page_size: str = None,
    token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the configuration, dimension, and other settings for all the versions of a specific segment that's associated with an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        segment_id(str): The unique identifier for the segment.
        token(str, optional): The NextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.segment.version.get_all(
                ctx, application_id=value, segment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.segment.version.get_all application_id=value, segment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_segment_versions",
        op_kwargs={
            "ApplicationId": application_id,
            "PageSize": page_size,
            "SegmentId": segment_id,
            "Token": token,
        },
    )
