"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, application_id: str, write_segment_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        write_segment_request(Dict): Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.segment.init.create(
                ctx, application_id=value, write_segment_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.segment.init.create application_id=value, write_segment_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="create_segment",
        op_kwargs={
            "ApplicationId": application_id,
            "WriteSegmentRequest": write_segment_request,
        },
    )


async def delete(hub, ctx, application_id: str, segment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a segment from an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        segment_id(str): The unique identifier for the segment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.segment.init.delete(
                ctx, application_id=value, segment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.segment.init.delete application_id=value, segment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="delete_segment",
        op_kwargs={"ApplicationId": application_id, "SegmentId": segment_id},
    )


async def get(hub, ctx, application_id: str, segment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the configuration, dimension, and other settings for a specific segment that's associated with an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        segment_id(str): The unique identifier for the segment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.segment.init.get(
                ctx, application_id=value, segment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.segment.init.get application_id=value, segment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_segment",
        op_kwargs={"ApplicationId": application_id, "SegmentId": segment_id},
    )


async def get_all(
    hub, ctx, application_id: str, page_size: str = None, token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        token(str, optional): The NextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.segment.init.get_all(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.segment.init.get_all application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_segments",
        op_kwargs={
            "ApplicationId": application_id,
            "PageSize": page_size,
            "Token": token,
        },
    )


async def update(
    hub, ctx, application_id: str, segment_id: str, write_segment_request: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        segment_id(str): The unique identifier for the segment.
        write_segment_request(Dict): Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.segment.init.update(
                ctx, application_id=value, segment_id=value, write_segment_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.segment.init.update application_id=value, segment_id=value, write_segment_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="update_segment",
        op_kwargs={
            "ApplicationId": application_id,
            "SegmentId": segment_id,
            "WriteSegmentRequest": write_segment_request,
        },
    )
