"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags_model: Dict) -> None:
    r"""
    **Autogenerated function**

    Adds one or more tags (keys and values) to an application, campaign, message template, or segment.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource.
        tags_model(Dict): Specifies the tags (keys and values) for an application, campaign, message template, or segment.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.resource.tag(ctx, resource_arn=value, tags_model=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.resource.tag resource_arn=value, tags_model=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagsModel": tags_model},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes one or more tags (keys and values) from an application, campaign, message template, or segment.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource.
        tag_keys(List): The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.resource.untag(ctx, resource_arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
