"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, create_recommender_configuration: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Pinpoint configuration for a recommender model.

    Args:
        create_recommender_configuration(Dict): Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.recommender_configuration.create(
                ctx, create_recommender_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.recommender_configuration.create create_recommender_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="create_recommender_configuration",
        op_kwargs={"CreateRecommenderConfiguration": create_recommender_configuration},
    )


async def delete(hub, ctx, recommender_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon Pinpoint configuration for a recommender model.

    Args:
        recommender_id(str): The unique identifier for the recommender model configuration. This identifier is displayed as the Recommender ID on the Amazon Pinpoint console.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.recommender_configuration.delete(
                ctx, recommender_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.recommender_configuration.delete recommender_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="delete_recommender_configuration",
        op_kwargs={"RecommenderId": recommender_id},
    )


async def get(hub, ctx, recommender_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about an Amazon Pinpoint configuration for a recommender model.

    Args:
        recommender_id(str): The unique identifier for the recommender model configuration. This identifier is displayed as the Recommender ID on the Amazon Pinpoint console.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.recommender_configuration.get(
                ctx, recommender_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.recommender_configuration.get recommender_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_recommender_configuration",
        op_kwargs={"RecommenderId": recommender_id},
    )


async def get_all(hub, ctx, page_size: str = None, token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about all the recommender model configurations that are associated with your Amazon Pinpoint account.

    Args:
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        token(str, optional): The NextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.recommender_configuration.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.recommender_configuration.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_recommender_configurations",
        op_kwargs={"PageSize": page_size, "Token": token},
    )


async def update(
    hub, ctx, recommender_id: str, update_recommender_configuration: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an Amazon Pinpoint configuration for a recommender model.

    Args:
        recommender_id(str): The unique identifier for the recommender model configuration. This identifier is displayed as the Recommender ID on the Amazon Pinpoint console.
        update_recommender_configuration(Dict): Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.recommender_configuration.update(
                ctx, recommender_id=value, update_recommender_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.recommender_configuration.update recommender_id=value, update_recommender_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="update_recommender_configuration",
        op_kwargs={
            "RecommenderId": recommender_id,
            "UpdateRecommenderConfiguration": update_recommender_configuration,
        },
    )
