"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def phone(hub, ctx, number_validate_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a phone number.

    Args:
        number_validate_request(Dict): Specifies a phone number to validate and retrieve information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.number_validate.phone(
                ctx, number_validate_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.number_validate.phone number_validate_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="phone_number_validate",
        op_kwargs={"NumberValidateRequest": number_validate_request},
    )
