"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(hub, ctx, application_id: str, message_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates and sends a direct message.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        message_request(Dict): Specifies the configuration and other settings for a message.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.message.send(
                ctx, application_id=value, message_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.message.send application_id=value, message_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="send_messages",
        op_kwargs={"ApplicationId": application_id, "MessageRequest": message_request},
    )
