"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, application_id: str, journey_id: str, journey_state_request: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Cancels (stops) an active journey.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        journey_id(str): The unique identifier for the journey.
        journey_state_request(Dict): Changes the status of a journey.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.journey.state.update(
                ctx, application_id=value, journey_id=value, journey_state_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.journey.state.update application_id=value, journey_id=value, journey_state_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="update_journey_state",
        op_kwargs={
            "ApplicationId": application_id,
            "JourneyId": journey_id,
            "JourneyStateRequest": journey_state_request,
        },
    )
