"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, application_id: str, write_journey_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a journey for an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        write_journey_request(Dict): Specifies the configuration and other settings for a journey.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.journey.init.create(
                ctx, application_id=value, write_journey_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.journey.init.create application_id=value, write_journey_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="create_journey",
        op_kwargs={
            "ApplicationId": application_id,
            "WriteJourneyRequest": write_journey_request,
        },
    )


async def delete(hub, ctx, application_id: str, journey_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a journey from an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        journey_id(str): The unique identifier for the journey.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.journey.init.delete(
                ctx, application_id=value, journey_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.journey.init.delete application_id=value, journey_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="delete_journey",
        op_kwargs={"ApplicationId": application_id, "JourneyId": journey_id},
    )


async def get(hub, ctx, application_id: str, journey_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the status, configuration, and other settings for a journey.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        journey_id(str): The unique identifier for the journey.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.journey.init.get(
                ctx, application_id=value, journey_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.journey.init.get application_id=value, journey_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_journey",
        op_kwargs={"ApplicationId": application_id, "JourneyId": journey_id},
    )


async def list_all(
    hub, ctx, application_id: str, page_size: str = None, token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the status, configuration, and other settings for all the journeys that are associated with an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        token(str, optional): The NextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.journey.init.list_all(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.journey.init.list_all application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="list_journeys",
        op_kwargs={
            "ApplicationId": application_id,
            "PageSize": page_size,
            "Token": token,
        },
    )


async def update(
    hub, ctx, application_id: str, journey_id: str, write_journey_request: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration and other settings for a journey.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        journey_id(str): The unique identifier for the journey.
        write_journey_request(Dict): Specifies the configuration and other settings for a journey.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.journey.init.update(
                ctx, application_id=value, journey_id=value, write_journey_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.journey.init.update application_id=value, journey_id=value, write_journey_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="update_journey",
        op_kwargs={
            "ApplicationId": application_id,
            "JourneyId": journey_id,
            "WriteJourneyRequest": write_journey_request,
        },
    )
