"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    application_id: str,
    journey_id: str,
    next_token: str = None,
    page_size: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        journey_id(str): The unique identifier for the journey.
        next_token(str, optional): The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.journey.execution.metric.get_all(
                ctx, application_id=value, journey_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.journey.execution.metric.get_all application_id=value, journey_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_journey_execution_metrics",
        op_kwargs={
            "ApplicationId": application_id,
            "JourneyId": journey_id,
            "NextToken": next_token,
            "PageSize": page_size,
        },
    )
