"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, application_id: str, export_job_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates an export job for an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        export_job_request(Dict): Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.export_job.create(
                ctx, application_id=value, export_job_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.export_job.create application_id=value, export_job_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="create_export_job",
        op_kwargs={
            "ApplicationId": application_id,
            "ExportJobRequest": export_job_request,
        },
    )


async def get(hub, ctx, application_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the status and settings of a specific export job for an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        job_id(str): The unique identifier for the job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.export_job.get(ctx, application_id=value, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.export_job.get application_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_export_job",
        op_kwargs={"ApplicationId": application_id, "JobId": job_id},
    )


async def get_all(
    hub, ctx, application_id: str, page_size: str = None, token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the status and settings of all the export jobs for an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        token(str, optional): The NextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.export_job.get_all(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.export_job.get_all application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_export_jobs",
        op_kwargs={
            "ApplicationId": application_id,
            "PageSize": page_size,
            "Token": token,
        },
    )
