"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the event stream for an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.event.stream.delete(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.event.stream.delete application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="delete_event_stream",
        op_kwargs={"ApplicationId": application_id},
    )


async def get(hub, ctx, application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the event stream settings for an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.event.stream.get(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.event.stream.get application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_event_stream",
        op_kwargs={"ApplicationId": application_id},
    )


async def put(hub, ctx, application_id: str, write_event_stream: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new event stream for an application or updates the settings of an existing event stream for an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        write_event_stream(Dict): Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access Management (IAM) role to use when publishing those events.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.event.stream.put(
                ctx, application_id=value, write_event_stream=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.event.stream.put application_id=value, write_event_stream=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="put_event_stream",
        op_kwargs={
            "ApplicationId": application_id,
            "WriteEventStream": write_event_stream,
        },
    )
