"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(hub, ctx, application_id: str, events_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        events_request(Dict): Specifies a batch of events to process.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.event.init.put_multiple(
                ctx, application_id=value, events_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.event.init.put_multiple application_id=value, events_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="put_events",
        op_kwargs={"ApplicationId": application_id, "EventsRequest": events_request},
    )
