"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, application_id: str, endpoint_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an endpoint from an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        endpoint_id(str): The unique identifier for the endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.endpoint.init.delete(
                ctx, application_id=value, endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.endpoint.init.delete application_id=value, endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="delete_endpoint",
        op_kwargs={"ApplicationId": application_id, "EndpointId": endpoint_id},
    )


async def get(hub, ctx, application_id: str, endpoint_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the settings and attributes of a specific endpoint for an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        endpoint_id(str): The unique identifier for the endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.endpoint.init.get(
                ctx, application_id=value, endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.endpoint.init.get application_id=value, endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_endpoint",
        op_kwargs={"ApplicationId": application_id, "EndpointId": endpoint_id},
    )


async def update(
    hub, ctx, application_id: str, endpoint_id: str, endpoint_request: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application. You can also use this operation to define custom attributes for an endpoint. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        endpoint_id(str): The unique identifier for the endpoint.
        endpoint_request(Dict): Specifies the channel type and other settings for an endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.endpoint.init.update(
                ctx, application_id=value, endpoint_id=value, endpoint_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.endpoint.init.update application_id=value, endpoint_id=value, endpoint_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="update_endpoint",
        op_kwargs={
            "ApplicationId": application_id,
            "EndpointId": endpoint_id,
            "EndpointRequest": endpoint_request,
        },
    )
