"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, application_id: str, write_campaign_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new campaign for an application or updates the settings of an existing campaign for an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        write_campaign_request(Dict): Specifies the configuration and other settings for a campaign.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.campaign.init.create(
                ctx, application_id=value, write_campaign_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.campaign.init.create application_id=value, write_campaign_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="create_campaign",
        op_kwargs={
            "ApplicationId": application_id,
            "WriteCampaignRequest": write_campaign_request,
        },
    )


async def delete(hub, ctx, application_id: str, campaign_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a campaign from an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        campaign_id(str): The unique identifier for the campaign.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.campaign.init.delete(
                ctx, application_id=value, campaign_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.campaign.init.delete application_id=value, campaign_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="delete_campaign",
        op_kwargs={"ApplicationId": application_id, "CampaignId": campaign_id},
    )


async def get(hub, ctx, application_id: str, campaign_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the status, configuration, and other settings for a campaign.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        campaign_id(str): The unique identifier for the campaign.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.campaign.init.get(
                ctx, application_id=value, campaign_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.campaign.init.get application_id=value, campaign_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_campaign",
        op_kwargs={"ApplicationId": application_id, "CampaignId": campaign_id},
    )


async def get_all(
    hub, ctx, application_id: str, page_size: str = None, token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        token(str, optional): The NextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.campaign.init.get_all(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.campaign.init.get_all application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_campaigns",
        op_kwargs={
            "ApplicationId": application_id,
            "PageSize": page_size,
            "Token": token,
        },
    )


async def update(
    hub, ctx, application_id: str, campaign_id: str, write_campaign_request: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration and other settings for a campaign.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        campaign_id(str): The unique identifier for the campaign.
        write_campaign_request(Dict): Specifies the configuration and other settings for a campaign.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.campaign.init.update(
                ctx, application_id=value, campaign_id=value, write_campaign_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.campaign.init.update application_id=value, campaign_id=value, write_campaign_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="update_campaign",
        op_kwargs={
            "ApplicationId": application_id,
            "CampaignId": campaign_id,
            "WriteCampaignRequest": write_campaign_request,
        },
    )
